<?php

	$params1 = array("Jeden" => 1, "Dwa" => "2 plus 2 = 4");
	$params2 = array("Trzy" => 3, "Cztery" => "4 godzina");

	$parser = new RESTParser();
	echo $parser->callService($params1, 'localhost', '/addiction/ch1/examples/RESTService.php', 'POST');
	echo "<hr>";
	echo $parser->callService($params2, 'localhost', '/addiction/ch1/examples/RESTService.php', 'GET');

class RESTParser {
	
	function callService($parameters, $remoteServer, $path, $httpMethod, $port=80) {
		$paramString = $this->makeParameterString($parameters);

		switch(strtoupper($httpMethod)) {
			case "POST":
				$fullRequest = $this->createPostRequest($remoteServer, $path, $paramString);
				break;
			case "GET":
				$fullRequest = $this->createGetRequest($remoteServer, $path, $paramString);
				break;
			default:
				$fullRequest = $this->createGetRequest($remoteServer, $path, $paramString);
		}		

		return $this->send($remoteServer, $port, $fullRequest);
	}
	
	function makeParameterString($anArray) {
		$returnMe = '';
		foreach($anArray as $key => $value) {
			$returnMe .= "&" . $key . "=" . urlencode($value);	
		}
		return substr($returnMe, 1);
	}
	
	function createPostRequest($remoteServer, $remotePath, $paramString) {
		$theRequest = "POST " . $remotePath . " HTTP/1.0\n" .
		"Host: " . $remoteServer . "\n" .
		"User-Agent: XML-RPC Client\n" .
		"Content-Type: application/x-www-form-urlencoded\n" . 
		"Content-Length: " .strlen($paramString) . "\n" .
		"\n" . $paramString . "\n";
		return $theRequest;
	}
	
	function createGetRequest($remoteServer, $remotePath, $paramString) {
		$theRequest = "GET " . $remotePath . "?" . $paramString . " HTTP/1.0\n" .
		"Host: " . $remoteServer . "\n" . 
		"User-Agent: XML-RPC Client\n\n";
		
		return $theRequest;
	}
	
	function send($remoteServer, $remotePort, $fullXMLRPCRequest) {
		$headers = '';
		$data = '';
		
		$socket = fsockopen($remoteServer, $remotePort);
		fwrite($socket, $fullXMLRPCRequest);
	
		while ($str = trim(fgets($socket))) {
			$headers .= $str . '\n';	
		}
			
		$data = '';
		while  (!feof($socket)) {
			$data .= fgets($socket);	
		}
		fclose($socket);
		return $data;
	
	}
}
?>